﻿using System.Collections;
using System.Collections.Generic;
using System.Text;
using UnityEngine;
using UnityEngine.UI;


public class Popup2 : MonoBehaviour
{
    public delegate void OnClick(bool isPastive);

    public GameObject popup2;

	public Text textTitle;
    public Text textMessage;
    public Text textButtonOk;
    public Text textButtonCancel;


    OnClick onClickListener;


    public void show(string buttonOk, OnClick onClickListener) {
        show(null, null, buttonOk, null, onClickListener);
    }

    public void show(string title, string message, string buttonOk, string buttonCancel, OnClick onClickListener) {
        this.onClickListener = onClickListener;

        if (LocalizationManager.instance.GetIsReady()) {
            #if UNITY_IOS
			PopupContent content = LocalizationManager.instance.GetLocalizedPopupValue("SUBSCRIPTION_INFO_IOS");
            #else
            PopupContent content = LocalizationManager.instance.GetLocalizedPopupValue("SUBSCRIPTION_INFO_ANDROID");
            #endif
			if (title == null) title = content.title;
			if (message == null) message = content.message;
            if (buttonCancel == null) buttonCancel = "CANCEL";
        }

        textTitle.text = title;
        textMessage.text = message;
        textButtonOk.text = buttonOk;
        textButtonCancel.text = buttonCancel;

        popup2.SetActive(true);
    }

    public void onClick() {
        dismiss();
        if (onClickListener != null) onClickListener(true);
    }

    public void onCancel() {
        dismiss();
        if (onClickListener != null) onClickListener(false);
    }

    public void dismiss() {
        popup2.SetActive(false);
    }
}
